function ntkresult = best_result_ntk(x,y,id)
kfold = max(id);
[~,T] = size(x);
L_iter = 1:10;
sigmab_iter = [0,0.01,0.1,0.2,0.5,0.8,1,2,5];
sigmaw_iter = [0.5,1,sqrt(2),2,2.5,3];
paramntk = struct();
paramntk.nonlinearity = 1;
acc_best = 0;
for i = 1:length(L_iter)
    for j = 1:length(sigmab_iter)
        for k = 1:length(sigmaw_iter)
            paramntk.sigmaw = sigmaw_iter(k);
            paramntk.sigmab = sigmab_iter(j);
            paramntk.L = L_iter(i);
            
            kernel_train = cell(kfold,1);
            kernel_test = cell(kfold,1);
            y_train = cell(kfold,1);
            y_test = cell(kfold,1);
            for q = 1:kfold
                id_train = find(id ~= q);
                id_test = find(id == q);
                kernel_train{q} = gramNTK(x(id_train,:),x(id_train,:),paramntk);
                kernel_test{q} = gramNTK(x(id_test,:),x(id_train,:),paramntk);
                y_train{q} = y(id_train);
                y_test{q} = y(id_test);
            end
            if  norm(kernel_train{1})/(size(kernel_train{1},1)^2) < 10^10
                [acc_current,svmparam] = give_me_best_acc_svm(kernel_train,kernel_test,y_train,y_test);
                if acc_current > acc_best
                   acc_best = acc_current
                   sigmaw_best = sigmaw_iter(k);
                   sigmab_best = sigmab_iter(j);
                   L_best = L_iter(i);
                   svmparam_best = svmparam;
                end
            end
        fprintf(' NTK : %.2f percent Complete with best kfold accuracy %.2f \n', 100*( (i-1)*( length(sigmab_iter)*length(sigmaw_iter) ) + (j-1)*length(sigmaw_iter) + k )/(length(L_iter)*length(sigmab_iter)*length(sigmaw_iter) ), acc_best )      
        end
    end
end
paramntk.sigmaw = sigmaw_best;
paramntk.L = L_best;
paramntk.sigmab = sigmab_best;
ntkresult = struct();
ntkresult.param = paramntk;
ntkresult.acc_kfold = acc_best;
ntkresult.svmparam = svmparam_best;
end

